//------------------------------------------------------------------------------
// File: client_menu.cs
//
// This file is used to handle the menu state progression.  The first part
// of this is the 3D background that is selected for the menu.  This
// background is randomly selected based on how the MenuMissions variables
// are set up.
//
// Menu states are defined later and are used to manipulate profiles, start
// tutorials, pick heroes, select maps, change options, etc.
//
// This file also contains major transitions between the menu and the game.
// In particular, this file contains functionality for exiting the game,
// entering the game, and entering the main menu after leaving the game.
//
// Author: Michael Felice
//------------------------------------------------------------------------------

exec("./audioFunctions.cs");

//*************************************************************
//                MAIN MENU ORDERING AND DISPLAY
//*************************************************************

// true if in a playable mission, false if not in a playable mission
$PlayingGame = false;
$MissionLoaded = false;
$CreateExperience = false;
$InGame = false;

// Used with loadMenuMission to determine where we came from
$LoadState = 0;
$MenuState = 1;
$GameState = 2;

// the list of possible menu backgrounds to use
$MenuMissions[0] = "assets/data/missions/menu3.mis";
$MenuMissions[1] = "assets/data/missions/menu7.mis";
$MenuMissions[2] = "assets/data/missions/menu6.mis";
$MenuMissionCount = 3;
$MenuGui = "MainMenuGui";
//$MenuGui = "PortraitCameraGui";
//$MenuGui = "ExperienceGui";

$ContinueMission = "";

// this returns the file name of the menu mission to use, which is
// randomly selected from the list of menu missions above
function getMenuMission()
{
   // if the game is going to determine best settings, use default map
   if ($pref::Game::FirstTimePlaying == true)
   {
      return $MenuMissions[0];
   }
   
   // get the index of the menu mission and return that
   %index = getRandom(0, $MenuMissionCount - 1);
   return $MenuMissions[%index];
}

function SaveMenus()
{
   slgSaveInt($SLGHERO_CURRENT);
   
   // save the minimap
   minimap.SaveToFile();
   
   // save the hero location button
   LocateHeroButton.SaveToFile();
   slgSaveString(LocateHeroButton.stateUp);
   slgSaveString(LocateHeroButton.stateFocus);
   
   // building buttons
   ShackButton.SaveToFile();
   LogcabinButton.SaveToFile();
   HotelButton.SaveToFile();
   WellButton.SaveToFile();
   FarmButton.SaveToFile();
   RanchButton.SaveToFile();
   WoodhutButton.SaveToFile();
   GoldMineButton.SaveToFile();
   WatertowerButton.SaveToFile();
   GranaryButton.SaveToFile();
   WindmillButton.SaveToFile();
   SmokehouseButton.SaveToFile();
   GeneralButton.SaveToFile();
   SaloonButton.SaveToFile();
   LumbermillButton.SaveToFile();
   BlacksmithButton.SaveToFile();
   SheriffsOfficeButton.SaveToFile();
   TradingpostButton.SaveToFile();
   BankButton.SaveToFile();
   TownhallButton.SaveToFile();
   WatchtowerButton.SaveToFile();
   BridgeButton.SaveToFile();
   GazeboButton.SaveToFile();
   ChurchButton.SaveToFile();
   BarbershopButton.SaveToFile();
   OuthouseButton.SaveToFile();
   WelcomesignButton.SaveToFile();
   FountainButton.SaveToFile();
   StatueButton.SaveToFile();
   TownbellButton.SaveToFile();
   FlowerpotButton.SaveToFile();
   CemeteryButton.SaveToFile();
   HoneypotButton.SaveToFile();
   slgSaveString(HoneypotButton.iconEnabled);
   slgSaveBool(HoneypotButton.input);
   
   // character command button images
   CharCmdButton0.SaveToFile();
   CharCmdButton1.SaveToFile();
   CharCmdButton2.SaveToFile();
   CharCmdButton3.SaveToFile();
   CharCmdButton4.SaveToFile();
   CharCmdButton5.SaveToFile();
   CharCmdButton6.SaveToFile();
   
   // character command button text
   CharCmdBtnText5.SaveToFile();
   CharCmdBtnText6.SaveToFile();
   
   // building command buttons images
   BldgCmdButton0.SaveToFile();
   BldgCmdButton1.SaveToFile();
   BldgCmdButton2.SaveToFile();
   BldgCmdButton3.SaveToFile();
   BldgCmdButton4.SaveToFile();
   BldgCmdButton5.SaveToFile();
   BldgCmdButton6.SaveToFile();
   BldgCmdButton7.SaveToFile();
   BldgCmdButton8.SaveToFile();
   BldgCmdButton9.SaveToFile();
   BldgCmdButton10.SaveToFile();
   BldgCmdButton11.SaveToFile();
   BldgCmdButton12.SaveToFile();
   BldgCmdButton13.SaveToFile();
   BldgCmdButton14.SaveToFile();
   BldgCmdButton15.SaveToFile();
   BldgCmdButton16.SaveToFile();
   BldgCmdButton17.SaveToFile();
   BldgCmdButton18.SaveToFile();
   BldgCmdButton19.SaveToFile();
   BldgCmdButton20.SaveToFile();
   BldgCmdButton21.SaveToFile();
   BldgCmdButton22.SaveToFile();
   BldgCmdButton23.SaveToFile();
   BldgCmdButton24.SaveToFile();
   BldgCmdButton25.SaveToFile();
   BldgCmdButton26.SaveToFile();
   BldgCmdButton27.SaveToFile();
   BldgCmdButton28.SaveToFile();
   BldgCmdButton29.SaveToFile();
   BldgCmdButton31.SaveToFile();
   BldgCmdButton32.SaveToFile();
   BldgCmdButton33.SaveToFile();
   BldgCmdButton40.SaveToFile();
   BldgCmdButton35.SaveToFile();
   BldgCmdButton36.SaveToFile();
   BldgCmdButton37.SaveToFile();
   BldgCmdButton38.SaveToFile();
   
   // building command buttons text
   BldgCmdBtnText0.SaveToFile();
   BldgCmdBtnText1.SaveToFile();
   BldgCmdBtnText2.SaveToFile();
   BldgCmdBtnText3.SaveToFile();
   BldgCmdBtnText4.SaveToFile();
   BldgCmdBtnText5.SaveToFile();
   BldgCmdBtnText9.SaveToFile();
   BldgCmdBtnText10.SaveToFile();
   BldgCmdBtnText11.SaveToFile();
   BldgCmdBtnText12.SaveToFile();
   BldgCmdBtnText29.SaveToFile();
   BldgCmdBtnText31.SaveToFile();
   BldgCmdBtnText32.SaveToFile();
   
   // save the default button list
   slgSaveInt($DefaultButtonCount);
   for (%index = 0; %index < $DefaultButtonCount; %index++)
   {
      %button = $DefaultButtonList[%index, 0];
      slgSaveString(idToName(%button));
      slgSaveBool($DefaultButtonList[%index, 1]);
   }
   
   // save the world map images
   slgSaveBool(tutorialworldmap.visible);
   slgSaveBool(campaign1worldmap.visible);
   slgSaveBool(campaign2worldmap.visible);
   slgSaveBool(fullworldmap.visible);
   
   // save campaign icons
   slgSaveBool(tutorialworldicon.visible);
   slgSaveBool(campaign1worldicon.visible);
   slgSaveBool(campaign2worldicon.visible);
   
   // save satellite icons (visibility)
   slgSaveBool(mapsatellite_deadmine.visible);
   slgSaveBool(mapsatellite_badseed.visible);
   slgSaveBool(mapsatellite_hoperescue.visible);
   slgSaveBool(mapsatellite_bridgedefense.visible);
   slgSaveBool(mapsatellite_spy.visible);
   slgSaveBool(mapsatellite_escort.visible);
   slgSaveBool(mapsatellite_famine.visible);
   slgSaveBool(mapsatellite_townhall.visible);
   slgSaveBool(mapsatellite_bakeoff.visible);
   slgSaveBool(mapsatellite_snakevalley.visible);
   slgSaveBool(mapsatellite_tornadovalley.visible);
   slgSaveBool(mapsatellite_whiteorwong.visible);
   slgSaveBool(mapsatellite_madrussian.visible);
   slgSaveBool(mapsatellite_finalwong.visible);
   slgSaveBool(mapsatellite_finalwhite.visible);
   slgSaveBool(mapsatellite_animaltrap.visible);
   slgSaveBool(mapsatellite_outpostfood.visible);
   slgSaveBool(mapsatellite_outpostwood.visible);
   slgSaveBool(mapsatellite_outpostgold.visible);
   
   // save satellite icons (disabled state)
   slgSaveBool(mapsatellite_deadmine.disabled);
   slgSaveBool(mapsatellite_badseed.disabled);
   slgSaveBool(mapsatellite_hoperescue.disabled);
   slgSaveBool(mapsatellite_bridgedefense.disabled);
   slgSaveBool(mapsatellite_spy.disabled);
   slgSaveBool(mapsatellite_escort.disabled);
   slgSaveBool(mapsatellite_famine.disabled);
   slgSaveBool(mapsatellite_townhall.disabled);
   slgSaveBool(mapsatellite_bakeoff.disabled);
   slgSaveBool(mapsatellite_snakevalley.disabled);
   slgSaveBool(mapsatellite_tornadovalley.disabled);
   slgSaveBool(mapsatellite_whiteorwong.disabled);
   slgSaveBool(mapsatellite_madrussian.disabled);
   slgSaveBool(mapsatellite_finalwong.disabled);
   slgSaveBool(mapsatellite_finalwhite.disabled);
   slgSaveBool(mapsatellite_animaltrap.disabled);
   slgSaveBool(mapsatellite_outpostfood.disabled);
   slgSaveBool(mapsatellite_outpostwood.disabled);
   slgSaveBool(mapsatellite_outpostgold.disabled);
}

function LoadMenus(%loadFlags)
{
   $SLGHERO_CURRENT = slgLoadInt();
   
   // load the minimap
   minimap.LoadFromFile();
   
   // load the hero location button
   LocateHeroButton.LoadFromFile();
   LocateHeroButton.stateUp = slgLoadString();
   LocateHeroButton.stateFocus = slgLoadString();
   LocateHeroButton.stateDown = LocateHeroButton.stateUp;
   
   // building buttons
   ShackButton.LoadFromFile();
   LogcabinButton.LoadFromFile();
   HotelButton.LoadFromFile();
   WellButton.LoadFromFile();
   FarmButton.LoadFromFile();
   RanchButton.LoadFromFile();
   WoodhutButton.LoadFromFile();
   GoldMineButton.LoadFromFile();
   WatertowerButton.LoadFromFile();
   GranaryButton.LoadFromFile();
   WindmillButton.LoadFromFile();
   SmokehouseButton.LoadFromFile();
   GeneralButton.LoadFromFile();
   SaloonButton.LoadFromFile();
   LumbermillButton.LoadFromFile();
   BlacksmithButton.LoadFromFile();
   SheriffsOfficeButton.LoadFromFile();
   TradingpostButton.LoadFromFile();
   BankButton.LoadFromFile();
   TownhallButton.LoadFromFile();
   WatchtowerButton.LoadFromFile();
   BridgeButton.LoadFromFile();
   GazeboButton.LoadFromFile();
   ChurchButton.LoadFromFile();
   BarbershopButton.LoadFromFile();
   OuthouseButton.LoadFromFile();
   WelcomesignButton.LoadFromFile();
   FountainButton.LoadFromFile();
   StatueButton.LoadFromFile();
   TownbellButton.LoadFromFile();
   FlowerpotButton.LoadFromFile();
   CemeteryButton.LoadFromFile();
   HoneypotButton.LoadFromFile();
   HoneypotButton.iconEnabled = slgLoadString();
   HoneypotButton.input = slgLoadBool();
   
   // character command button images
   CharCmdButton0.LoadFromFile();
   CharCmdButton1.LoadFromFile();
   CharCmdButton2.LoadFromFile();
   CharCmdButton3.LoadFromFile();
   CharCmdButton4.LoadFromFile();
   CharCmdButton5.LoadFromFile();
   CharCmdButton6.LoadFromFile();
   
   // character command button text
   CharCmdBtnText5.LoadFromFile();
   CharCmdBtnText6.LoadFromFile();
   
   // building command buttons images
   BldgCmdButton0.LoadFromFile();
   BldgCmdButton1.LoadFromFile();
   BldgCmdButton2.LoadFromFile();
   BldgCmdButton3.LoadFromFile();
   BldgCmdButton4.LoadFromFile();
   BldgCmdButton5.LoadFromFile();
   BldgCmdButton6.LoadFromFile();
   BldgCmdButton7.LoadFromFile();
   BldgCmdButton8.LoadFromFile();
   BldgCmdButton9.LoadFromFile();
   BldgCmdButton10.LoadFromFile();
   BldgCmdButton11.LoadFromFile();
   BldgCmdButton12.LoadFromFile();
   BldgCmdButton13.LoadFromFile();
   BldgCmdButton14.LoadFromFile();
   BldgCmdButton15.LoadFromFile();
   BldgCmdButton16.LoadFromFile();
   BldgCmdButton17.LoadFromFile();
   BldgCmdButton18.LoadFromFile();
   BldgCmdButton19.LoadFromFile();
   BldgCmdButton20.LoadFromFile();
   BldgCmdButton21.LoadFromFile();
   BldgCmdButton22.LoadFromFile();
   BldgCmdButton23.LoadFromFile();
   BldgCmdButton24.LoadFromFile();
   BldgCmdButton25.LoadFromFile();
   BldgCmdButton26.LoadFromFile();
   BldgCmdButton27.LoadFromFile();
   BldgCmdButton28.LoadFromFile();
   BldgCmdButton29.LoadFromFile();
   BldgCmdButton31.LoadFromFile();
   BldgCmdButton32.LoadFromFile();
   BldgCmdButton33.LoadFromFile();
   BldgCmdButton40.LoadFromFile();
   BldgCmdButton35.LoadFromFile();
   BldgCmdButton36.LoadFromFile();
   BldgCmdButton37.LoadFromFile();
   BldgCmdButton38.LoadFromFile();
   
   // building command buttons text
   BldgCmdBtnText0.LoadFromFile();
   BldgCmdBtnText1.LoadFromFile();
   BldgCmdBtnText2.LoadFromFile();
   BldgCmdBtnText3.LoadFromFile();
   BldgCmdBtnText4.LoadFromFile();
   BldgCmdBtnText5.LoadFromFile();
   BldgCmdBtnText9.LoadFromFile();
   BldgCmdBtnText10.LoadFromFile();
   BldgCmdBtnText11.LoadFromFile();
   BldgCmdBtnText12.LoadFromFile();
   BldgCmdBtnText29.LoadFromFile();
   BldgCmdBtnText31.LoadFromFile();
   BldgCmdBtnText32.LoadFromFile();
   
   // load the default button list
   $DefaultButtonCount = slgLoadInt();
   for (%index = 0; %index < $DefaultButtonCount; %index++)
   {
      %buttonName = slgLoadString();
      $DefaultButtonList[%index, 0] = nameToId(%buttonName);
      $DefaultButtonList[%index, 1] = slgLoadBool();
   }
   
   // load the world map images
   tutorialworldmap.visible = slgLoadBool();
   campaign1worldmap.visible = slgLoadBool();
   campaign2worldmap.visible = slgLoadBool();
   fullworldmap.visible = slgLoadBool();
   
   // load campaign icons
   tutorialworldicon.visible = slgLoadBool();
   campaign1worldicon.visible = slgLoadBool();
   campaign2worldicon.visible = slgLoadBool();
   
   // load satellite icons (visibility)
   mapsatellite_deadmine.visible = slgLoadBool();
   mapsatellite_badseed.visible = slgLoadBool();
   mapsatellite_hoperescue.visible = slgLoadBool();
   mapsatellite_bridgedefense.visible = slgLoadBool();
   mapsatellite_spy.visible = slgLoadBool();
   mapsatellite_escort.visible = slgLoadBool();
   mapsatellite_famine.visible = slgLoadBool();
   mapsatellite_townhall.visible = slgLoadBool();
   mapsatellite_bakeoff.visible = slgLoadBool();
   mapsatellite_snakevalley.visible = slgLoadBool();
   mapsatellite_tornadovalley.visible = slgLoadBool();
   mapsatellite_whiteorwong.visible = slgLoadBool();
   mapsatellite_madrussian.visible = slgLoadBool();
   mapsatellite_finalwong.visible = slgLoadBool();
   mapsatellite_finalwhite.visible = slgLoadBool();
   mapsatellite_animaltrap.visible = slgLoadBool();
   mapsatellite_outpostfood.visible = slgLoadBool();
   mapsatellite_outpostwood.visible = slgLoadBool();
   mapsatellite_outpostgold.visible = slgLoadBool();
   
   // load satellite icons (disabled state)
   if (%loadFlags == true)
   {
      mapsatellite_deadmine.disabled = slgLoadBool();
      mapsatellite_badseed.disabled = slgLoadBool();
      mapsatellite_hoperescue.disabled = slgLoadBool();
      mapsatellite_bridgedefense.disabled = slgLoadBool();
      mapsatellite_spy.disabled = slgLoadBool();
      mapsatellite_escort.disabled = slgLoadBool();
      mapsatellite_famine.disabled = slgLoadBool();
      mapsatellite_townhall.disabled = slgLoadBool();
      mapsatellite_bakeoff.disabled = slgLoadBool();
      mapsatellite_snakevalley.disabled = slgLoadBool();
      mapsatellite_tornadovalley.disabled = slgLoadBool();
      mapsatellite_whiteorwong.disabled = slgLoadBool();
      mapsatellite_madrussian.disabled = slgLoadBool();
      mapsatellite_finalwong.disabled = slgLoadBool();
      mapsatellite_finalwhite.disabled = slgLoadBool();
      mapsatellite_animaltrap.disabled = slgLoadBool();
      mapsatellite_outpostfood.disabled = slgLoadBool();
      mapsatellite_outpostwood.disabled = slgLoadBool();
      mapsatellite_outpostgold.disabled = slgLoadBool();
   }
   else
   {
      slgLoadBool();
      slgLoadBool();
      slgLoadBool();
      slgLoadBool();
      slgLoadBool();
      slgLoadBool();
      slgLoadBool();
      slgLoadBool();
      slgLoadBool();
      slgLoadBool();
      slgLoadBool();
      slgLoadBool();
      slgLoadBool();
      slgLoadBool();
      slgLoadBool();
      slgLoadBool();
      slgLoadBool();
      slgLoadBool();
      slgLoadBool();
   }
}

function initializeMainMenu()
{
   // initialize the huds
   $SLGHERO_CURRENT = -1;
   HeroDescription.stateUp = "";   
   HeroButton0.selected = false;
   HeroButton1.selected = false;
   HeroButton2.selected = false;
   HeroName0.selected = false;
   HeroName1.selected = false;
   HeroName2.selected = false;
   HeroPlay.disabled = true;
   HoneypotButton.input = false;
   HoneypotButton.disabled = true;
   HoneypotButton.iconEnabled = "";
   
   // this loads all buttons needed
   LoadStartButtons();
   
   InitializeQuestGui();
   InitHudQuests();
   InitializeFOW();
   InitializeProduceBadges();
   checkForSandbox();
   
   GameOptionsResolutionMenu.loadOptions();
}

// this will load the menu mission (parameter passed determines where we came
// from, either load, menu, or game. If from load or game, the mission will be
// loaded with the menu gui; otherwise, just the menu gui will be loaded)
// \param %loadMission Use $LoadState, $MenuState, or $GameState
$FirstMissionLoaded = true;
function loadMenuMission(%loadMission)
{
   $InGame = false;
   UnloadGameActions();
   initializeMainMenu();
   updateProfileName();
   
   // Ending the main game
   if (%loadMission == $GameState)
   {
      profilerDump();
      clientEndGame(false);
   }
   
   $SplashLoadEnd = $MenuGui;
   
   // if the mission should be loaded, set up the ending gui for
   // the loading screen to be the main menu and load the mission
   $ReloadExperience = true;
   if (%loadMission != $MenuState)
   {
      %mission = getMenuMission();
      loadMission(%mission, $FirstMissionLoaded);
      $FirstMissionLoaded = false;
   }

   // make sure the audio initialized
   if($Audio::initFailed) {
      MessageBoxOK("Audio Initialization Failed", 
         "The OpenAL audio system failed to initialize.  " @
         "You can get the most recent OpenAL drivers <a:www.garagegames.com/docs/torque/gstarted/openal.html>here</a>.");
   }
   
   // use the default cursor for the menu screen
   csUpdateCursor($CSC_NONE);
   
   // handle destroying game objects
   if ($PlayingGame == true)
   {
      $PlayingGame = false;

      // destruction of game components
      DestroyHudMessages();
      slgDestroyClientCommandSystem();
      slgDestroyClientTaskSystem();
      slgResetLocatorIndexes();

      commandToServer('DestroyDisasterManager', ServerConnection);
      commandToServer('RebuildServerSystems', ServerConnection);
      commandToServer('DestroyResources');
   }
}


//*************************************************************
//                 MENU PROGRESSION FUNCTIONALITY
//*************************************************************

$MenuProgressIndex = -1;
$MenuProgress = 0;
$MenuDirection = 1;

// move to the next menu state
function nextMenuState()
{
   $MenuProgressIndex++;

   // if the next menu state is not defined, then we have a problem
   if ($MenuProgress[$MenuProgressIndex] $= "")
   {
      error("Menu Progress Error: no next menu state to move to-- aborting.");
      return;
   }

   // load the next menu state
   $MenuDirection = 1;
   call($MenuProgress[$MenuProgressIndex]);
}

// move to the previous menu state
function prevMenuState(%dialog)
{
   $MenuProgressIndex--;
   
   // pop the previous dialog that was pushed
   if (%dialog !$= "")
   {
      Canvas.popDialog(%dialog);
   }

   // if the previous menu state is before the menu progression index,
   // then we need to return to the main menu
   if ($MenuProgressIndex == -1)
   {
      enterMenu();
      return;
   }

   // if the previous menu state is not defined, then we have a problem
   if ($MenuProgress[$MenuProgressIndex] $= "")
   {
      error("Menu Progress Error: no previous menu state to move to-- aborting.");
      return;
   }

   // load the next menu state
   $MenuDirection = -1;
   call($MenuProgress[$MenuProgressIndex]);
}

// move to the next menu state in the same direction (next/prev) that
// the last menu state was changed to
function continueMenuState()
{
   // check if the next menu state should be selected
   if ($MenuDirection == 1)
   {
      nextMenuState();
      return;
   }

   // check if the previous menu state should be selected
   if ($MenuDirection == -1)
   {
      prevMenuState();
      return;
   }
   
   error("No menu direction has been set: cannot continue menu state-- aborting.");
}



//*************************************************************
//                    INITIAL MENU PROGRESSION
//*************************************************************

// call this function to load the new game menu state progression
function loadNewGameMenu()
{
   $CreateExperience = true;
   $LookGameProfile = false;
   $MenuProgressIndex = -1;

   $MenuProgress[0] = checkProfile;
   $MenuProgress[1] = pickHero;
   $MenuProgress[2] = checkTutorial;
   $MenuProgress[3] = pickMap;
   $MenuProgress[4] = addHero;
   $MenuProgress[5] = enterGame;
   
   nextMenuState();
}

$SandboxMapSelected = false;

// call this function to load the new sandbox mode menu state progression
function loadNewSandboxMenu()
{
   $CreateExperience = true;
   $LookGameProfile = false;
   $MenuProgressIndex = -1;

   $MenuProgress[0] = checkProfile;
   $MenuProgress[1] = pickHero;
   $MenuProgress[2] = checkTutorial;
   $MenuProgress[3] = pickSandboxMap;
   $MenuProgress[4] = addHero;
   $MenuProgress[5] = enterSandbox;
   
   /*
   $MenuProgress[3] = addHero;
   $MenuProgress[4] = enterSandbox;
   */
   
   nextMenuState();
}

// call this function to load the load game menu state progression
function loadLoadGameMenu()
{
   $CreateExperience = false;
   $LookGameProfile = false;
   $MenuProgressIndex = -1;

   $MenuProgress[0] = pickGame;
   $MenuProgress[1] = loadGame;
   
   nextMenuState();
}

// call this function to load the continue game menu state progression
function loadContinueGameMenu()
{
   $CreateExperience = false;
   $LookGameProfile = false;
   $MenuProgressIndex = -1;

   $MenuProgress[0] = continueGame;
   
   //Get the current profile's last save game
   %slot = slgLastLoadedSave();
   %file = slgGetSaveGamePath(%slot);
   LoadGame(%slot, %file, "slgUnpauseGame", true);
   
   /*
   $ContinueMission = slgGetSaveGamePath(%savedSlot);
   if(!slgFileExists($ContinueMission))
      $ContinueMission = "";
   nextMenuState();
   */
}

// call this function to load the exit game menu state progression
function loadExitGameMenu()
{
   $CreateExperience = false;
   $LookGameProfile = false;
   $MenuProgressIndex = -1;

   $MenuProgress[0] = exitGame;
   
   nextMenuState();
}

// call this function to load the profile menu state progression
function loadProfileMenu()
{
   $CreateExperience = false;
   $LookGameProfile = false;
   $MenuProgressIndex = -1;

   $MenuProgress[0] = checkProfile;
   $MenuProgress[1] = pickProfile;
   $MenuProgress[2] = exitProfile;
   $MenuProgress[3] = enterMenu;
   
   nextMenuState();
}

// call this function to load the options menu state progression
function loadOptionsMenu()
{
   $CreateExperience = false;
   $LookGameProfile = false;
   $MenuProgressIndex = -1;

   $MenuProgress[0] = pickOptions;
   $MenuProgress[1] = enterMenu;
   
   nextMenuState();
}



//*************************************************************
//                   CONDITIONAL MENU PROGRESSION
//*************************************************************

$GameProfile = 1;
$GameTutorial = 1;

// this checks if a profile has been selected (if it has, it will
// move to the next menu state; otherwise, it will move to the
// profile selection screen
function checkProfile()
{
   $NewGameProfile = false;
   
   // if a game profile already exists, progress to the next menu state
   if (slgCurrentProfileValid() || $LookGameProfile == true)
   {
      $LookGameProfile = true;
      continueMenuState();
      return;
   }
   
   $LookGameProfile = true;
   $NewGameProfile = true;
   CreateProfileBack.disabled = true;

   /*
   // if no profile has been selected, pick a profile
   Canvas.setContent(MainMenuGui);
   Canvas.pushDialog(profileStart);
   */
   
   // set up the notification window, which will explain that
   // a profile name will need to be created
   Canvas.setContent(MainMenuGui);
   notificationWindow("Before starting a new game, a profile needs to be created.  A profile will be created with the name you create, and all of your saved games can be loaded through this profile.", "Canvas.pushDialog(createProfile);");
}

// this checks if the tutorial has been completed (if it has, it
// will move to the next menu state; otherwise, it will start the
// game tutorial.
function checkTutorial()
{
   // if a tutorial has been completed for this profile, move to the
   // next menu state
   if ($GameTutorial)
   {
      continueMenuState();
      return;
   }

   // if no tutorial has been completed for this profile, start the tutorial
   pickTutorial();
}



//*************************************************************
//                    SELECTION MENU PROGRESSION
//*************************************************************

// this is called when a hero needs to be selected by the player
function pickHero()
{
   Canvas.setContent(MainMenuGui);
   Canvas.pushDialog(selectCharacterGui);
   metrics("fps");
}

// this is called when the map needs to be selected by the player
function pickMap()
{
   // check if the tutorial has already been completed
   if (tsUseTutorialMap() == false)
   {
      Canvas.popDialog(SelectCharacterGui);
      Canvas.pushDialog(TutorialSelectGui);
   }
   // if it has not, force the player to play the tutorial
   else
   {
      $UseTutorialMap = true;
      continueMenuState();
   }
}

// this is called when the sandbox map needs to be selected
function pickSandboxMap()
{
   // prepare the sandbox different maps that can be selected
   SandboxMap1.visible = false;
   SandboxMap2.visible = false;
   initializeSanboxMapList();
   
   // show the sandbox map selection
   Canvas.popDialog(selectCharacterGui);
   Canvas.pushDialog(SandboxMapGui);
   
   // check if a sandbox map should be initialized
   if ($SandboxMapSelected == false)
   {
      $SandboxMapSelected = true;
      updateSandboxMap(0);
   }
}

$SandboxMapCount = 0;
$SandboxMapList = "";
function initializeSanboxMapList()
{
   // get the sandbox button positioning
   %xPos = getWord(SandboxMap1.position, 0);
   %yPos = getWord(SandboxMap1.position, 1);
   %yOffset = getWord(SandboxMap2.position, 1) - %yPos;
   
   // remove all of the old sandbox map buttons
   for (%index = 0; %index < $SandboxMapCount; %index++)
   {
      $SandboxMapList[%index, 0].delete();
   }
   
   // create new sandbox map buttons
   $SandboxMapCount = 0;
   %sandboxMapDirectory = "assets/data/missions/sandlot/sandbox/*.mis.dso";
   %sandboxTerDirectory = "assets/data/missions/sandlot/sandbox/*.ter";
   %mapFile = findFirstFile(%sandboxMapDirectory);
   while (%mapFile !$= "")
   {
      %base = fileBase(fileBase(%mapFile));
      $SandboxMapList[$SandboxMapCount, 1] = %base;
      %button = new SLTextImage()
      {
         textUp = %base;
         textFocus = %base;
         textDown = %base;
         stateUp = SandboxMap1.stateUp;
         stateFocus = SandboxMap1.stateFocus;
         stateDown = SandboxMap1.stateDown;
         Profile = SandboxMap1.Profile;
         HorizSizing = "relative";
         VertSizing = "relative";
         position = %xPos @ " " @ %yPos + %yOffset * $SandboxMapCount;
         extent = SandboxMap1.extent;
         visible = true;
         input = true;
         command = "updateSandboxMap(" @ $SandboxMapCount @ ");";
      };
      SandboxScrollControl.addGuiControl(%button);
      $SandboxMapList[$SandboxMapCount, 0] = %button;
      
      $SandboxMapCount++;
      %mapFile = findNextFile(%sandboxMapDirectory);
   }
   
   %sandboxMapDirectory = "assets/data/missions/sandlot/sandbox/*.mis";
   %sandboxTerDirectory = "assets/data/missions/sandlot/sandbox/*.ter";
   %mapFile = findFirstFile(%sandboxMapDirectory);
   while (%mapFile !$= "")
   {
      %found = false;
      %base = fileBase(%mapFile);
      for (%index = 0; %index < $SandboxMapCount; %index++)
      {
         if (%base $= $SandboxMapList[%index, 1])
         {
            %found = true;
            break;
         }
      }
      
      if (%found == true)
      {
         %mapFile = findNextFile(%sandboxMapDirectory);
         continue;
      }
      
      $SandboxMapList[$SandboxMapCount, 1] = %base;
      %button = new SLTextImage()
      {
         textUp = %base;
         textFocus = %base;
         textDown = %base;
         stateUp = SandboxMap1.stateUp;
         stateFocus = SandboxMap1.stateFocus;
         stateDown = SandboxMap1.stateDown;
         Profile = SandboxMap1.Profile;
         HorizSizing = "relative";
         VertSizing = "relative";
         position = %xPos @ " " @ %yPos + %yOffset * $SandboxMapCount;
         extent = SandboxMap1.extent;
         visible = true;
         input = true;
         command = "updateSandboxMap(" @ $SandboxMapCount @ ");";
      };
      SandboxScrollControl.addGuiControl(%button);
      $SandboxMapList[$SandboxMapCount, 0] = %button;
      
      $SandboxMapCount++;
      %mapFile = findNextFile(%sandboxMapDirectory);
   }
   
   // update the extent of the hud based on how many maps there are
   %button = $SandboxMapList[$SandboxMapCount - 1, 0];
   %xExtent = getWord(SandboxScrollControl.extent, 0);
   %yExtent = getWord(%button.position, 1) + getWord(%button.extent, 1);
   SandboxScrollControl.extent = %xExtent @ " " @ %yExtent;
   
   // disable the play button
   SandboxMapPlay.disabled = true;
}

$UseSandboxMap = "";
function updateSandboxMap(%index)
{
   %base = $SandboxMapList[%index, 1];
   SandboxMapPlay.disabled = false;
   SandboxMapImage.stateUp = "assets/data/missions/sandlot/sandbox/" @ %base;
   $UseSandboxMap = %base;
   
   // update the states of the buttons
   for (%n = 0; %n < $SandboxMapCount; %n++)
   {
      $SandboxMapList[%n, 0].selected = (%n == %index);
   }
}

// this is called when the profile needs to be selected by the player
$MaxProfileCount = 6;
function pickProfile()
{
   Canvas.setContent(MainMenuGui);
   Canvas.pushDialog(profileStart);
   
   updateProfile();
}

function updateProfile()
{
   // set the active and inactive states in the profile
   %profileCount = slgGetNumProfiles();
   for (%index = 0; %index < $MaxProfileCount; %index++)
   {
      %profileControl = nameToId("ProfileCtrl" @ %index);
      %profileDelete = nameToId("ProfileDel" @ %index);
      
      %disabled = %index >= %profileCount;
      %profileControl.selected = false;
      %profileControl.disabled = %disabled;
      %profileDelete.disabled = %disabled;
   }
   CreateProfileButton.disabled = (%profileCount == $MaxProfileCount);
   
   // select the currently selected profile
   %profileSelected = slgGetCurrentProfileIndex();
   if (%profileSelected >= 0 && %profileSelected < %profileCount)
   {
      %profileControl = nameToId("ProfileCtrl" @ %profileSelected);
      %profileControl.selected = true;
   }
   
   updateProfileName();
}

// this is called when the options needs to be updated by the player
function pickOptions()
{
   Canvas.setContent(MainMenuGui);
   Canvas.pushDialog(GameOptionsGui);
   metrics("fps");
}

// this is called when the game needs to be selected by the player
function pickGame()
{
   Canvas.setContent(MainMenuGui);
   Canvas.pushDialog(loadGameGui);
   slgPopulateLoadButtons();
   metrics("fps");
}



//*************************************************************
//                   ADDING MENU PROGRESSION
//*************************************************************

// this function tells the server to create a hero character for
// the player and updates the hero character on the server
function addHero()
{
   commandToServer('OnHeroSelect', $SLGHERO_CURRENT);
   continueMenuState();
}


//*************************************************************
//            EXITING AND ENTERING MENU PROGRESSION
//*************************************************************

function exitProfile()
{
   Canvas.popDialog(createProfile);
   Canvas.popDialog(profileStart);
   nextMenuState();
}

// this function is called when the menu is loaded from the game
function enterMenu()
{
   // load the menu mission and menu
   loadMenuMission($MenuState);
   metrics("fps");
}

function initializeGame()
{
   // set up the mission
   $LoadingGuiContent = "LoadingGui";
   $SplashLoadEnd = "PlayGui";
   $CreateResources = true;
   
   PlayHud.visible = true;
   BuildingHud.visible = false;
   CharacterHud.visible = false;
   BuildHud1.visible = false;
   BuildHud2.Visible = false;
   BuildHud3.Visible = false;
   Build1Tab1.selected = false;
   Build2Tab1.selected = false;
   Build3Tab1.selected = false;
   Build1Tab2.selected = false;
   Build2Tab2.selected = false;
   Build3Tab2.selected = false;
   Build1Tab3.selected = false;
   Build2Tab3.selected = false;
   Build3Tab3.selected = false;
   ToolHud.Visible = false;
   PortraitHud.visible = false;
   BuildingRotate1.visible = false;
   BuildingRotate2.visible = false;
   BuildingRotate3.visible = false;
   muteSoundFX(false);
   
   if ($PlayingGame == false)
   {
      $PlayingGame = true;

      // construction of game components.
      slgBuildClientCommandSystem();
      slgStartClientCommandSystem();
   }
}

// this function is called when the game starts from menu selection
function enterGame()
{
   $InGame = true;
   initializeGame();
   slgSetSandbox(false);
   
   //Load the mission specified, or if none were specified, load the default
   $ReloadExperience = true;
   $ContinueMission = "";
   
   // check if the tutorial map should be loaded
   if ($UseTutorialMap == true)
   {
      // initialize the minimap image that is used and start the mission
      minimap.path = "assets/client/ui/minimaps/tutorialminimap.png";
      loadMission("assets/data/missions/sandlot/tutorial.mis", false);
   }
   else
   {
      minimap.path = "assets/client/ui/minimaps/campaign1minimap.png";
      loadMission("assets/data/missions/sandlot/mainmap.mis", false);
   }
   
   %client = ClientGroup.getObject(0);
   serverCmdDestroyDisasterManager(%client);
   CreateDisasterManager();
   
   if ($UseTutorialMap == true)
   {
      schedule(100, 0, onTutorialStart);
   }
   else
   {
      schedule(100, 0, onGameStart);
   }
}

function ChooseTutorialStart()
{
   $UseTutorialMap = true;
   nextMenuState();
}

function ChooseGameStart()
{
   $UseTutorialMap = false;
   nextMenuState();
}

function onTutorialStart()
{
   if ($MissionLoaded == true)
   {
      profilerEnable(true);
      slgBuildClientTutorialTaskSystem();
      LoadGameActions();
      return;
   }
   
   schedule(100, 0, onTutorialStart);
}

function onGameStart()
{
   if ($MissionLoaded == true)
   {
      profilerEnable(true);
      slgBuildClientGameTaskSystem();
      LoadGameActions();
      return;
   }
   
   schedule(100, 0, onGameStart);
}

function enterSandbox()
{
   $InGame = true;
   initializeGame();
   slgSetSandbox(true);
   
   $ReloadExperience = true;
   $ContinueMission = "";
   
   // initialize the minimap image that is used and start the mission
   minimap.path = "assets/client/ui/sandbox/" @ $UseSandboxMap;
   loadMission("assets/data/missions/sandlot/sandbox/" @ $UseSandboxMap @ ".mis", false);
   
   %client = ClientGroup.getObject(0);
   serverCmdDestroyDisasterManager(%client);
   CreateDisasterManager();
   
   schedule(100, 0, onSandboxStart);
}

function onSandboxStart()
{
   if ($MissionLoaded == true)
   {
      profilerEnable(true);
      slgBuildClientSandboxTaskSystem();
      LoadGameActions();
      return;
   }
   
   schedule(100, 0, onSandboxStart);
}

function onGameLoad()
{
   if ($MissionLoaded == true)
   {
      slgStartLoadGame($LoadMission, $LoadSlot);
      commandToServer('LoadObjectData', $LoadMission, $LoadSlot);
      
      if ($InGame == false)
      {
         $InGame = true;
         profilerEnable(true);
         slgBuildClientGameTaskSystem();
      }
      
      LoadGameActions();
      metrics("fps");
      return;
   }
   
   schedule(100, 0, onGameLoad);
}

function continueGame()
{
   //Get the mission name
   %slot = slgLastLoadedSave();
   %mission = slgGetSaveGamePath(%slot);
   
   //Change the mission
   if ($PlayingGame == false)
   {
	   initializeGame();
   }

   LoadGame(%slot, %mission, "onGameLoad", true);
}

function changeMission(%mission, %function, %ignoreWait)
{   
   $LoadingGuiContent = "LoadingGui";
   $SplashLoadEnd = "PlayGui";
   loadMission(%mission, false, %ignoreWait);
   
   // clear various systems
   alertDestroySystem();
   ClearResourceInfo();
   clearProductionBoosts();
   tsStopTaskListener();
   DestroyHudMessages();
   
   onMissionChanged(%function);
}

function onMissionChanged(%function)
{
   if ($MissionLoaded == true)
   {
      if (%function !$= "")
      {
         tsStartTaskListener();
         call(%function);
      }
      else
      {
         StopWaiting();
      }
      return;
   }
   
   schedule(100, 0, "onMissionChanged", %function);
}

// this function is called when the game is exited (from the menu or
// from the game)
function exitGame()
{
   quit();
}

function loadMenuMusic()
{
   playMusic(MusicMainMenu);
}

function loadMissionMusic()
{
   %i = RandomNumber(0,3);
   playMusic(MusicInGame @ %i);
   startAmbientSound();
}

//*************************************************************
//                   PROFILE MENU
//*************************************************************
//sets the current profile to be the one in the slot specified.
//If there isn't one there the createProfile dialog is launched.
function setProfile(%index)
{
   //If the profile exists, then set the game to that profile.
   if (slgProfileExists(%index))
   {
      slgSetCurrentProfile(%index);
      %file = slgGetSaveProfilePath();
      slgLoadProfile(%file);
      checkForSandbox();
      
      for (%profileIndex = 0; %profileIndex < $MaxProfileCount; %profileIndex++)
      {
         %profileControl = nameToId("ProfileCtrl" @ %profileIndex);
         %profileControl.selected = (%profileIndex == %index);
      }
      return;
   }
   
   //If the profile does not exist, prompt the user to create it.
   Canvas.pushDialog(createProfile);
   createProfileTextField.initialize();
   slgSetMainMenuWelcomeText();
}

function notificationWindow(%text, %execute)
{
   Canvas.pushDialog(NotificationGui);
   
   NotificationText.stateUp = %text;
   NotificationDone.command = %execute;
}

function confirmNewProfile()
{
   %text = createProfileTextField.getText();
   %check = slgValidateProfileName(%text, "invalidFilenameChars");
   switch(%check)
   {
   case $ProfileText::Okay:
      createNewProfile(%text);
      updateProfile();
      
      // select the profile that was created
      %profileControl = nameToId("ProfileCtrl" @ %selectIndex);
      %profileControl.selected = true;
      
      // unselect the profile that was not created
      if (%lastIndex != -1)
      {      
         %profileControl = nameToId("ProfileCtrl" @ %lastIndex);
         %profileControl.selected = false;
      }

      // save the newly created profile
      %file = slgGetSaveProfilePath();
      slgSaveCurrentProfile(%file);
      
      if ($NewGameProfile == true)
      {
         $NewGameProfile = false;
         Canvas.popDialog(createProfile);
         Canvas.popDialog(NotificationGui);
         CreateProfileBack.disabled = false;
         nextMenuState();
      }
      else
      {
         prevMenuState(createProfile);
      }
      
   case $ProfileText::Empty:
      Canvas.popDialog();
      %text = "No name was entered into the text window.  A profile cannot be created without a name.";
      notificationWindow(%text, "prevMenuState(NotificationGui);");
      
      // initialize the text back to its original state
      createProfileTextField.initialize();
      
   case $ProfileText::Invalid:
      Canvas.popDialog();
      %invalid = slgGetInvalidProfileChars();
      %text = "The following characters cannot be used to make a valid profile name: ";
      %count = getWordCount(%invalid);
      for (%index = 0; %index < %count; %index++)
      {
         %char = getWord(%invalid, %index);
         
         if (%index == 0 && %count < 3) %text = %text @ %char;
         else if (%index == %count - 1) %text = %text @ "and " @ %char;
         else %text = %text @ %char @ ",";
         if (%index != %count - 1) %text = %text @ " ";
      }
      %text = %text @ ".  Create a new profile name.";
      notificationWindow(%text, "prevMenuState(NotificationGui);");
   
   case $ProfileText::Duplicate:
      Canvas.popDialog();
      %text = "\"" @ createProfileTextField.getText() @ "\" is the name of a profile that already exists.  A new profile could not be created with this name.";
      notificationWindow(%text, "prevMenuState(NotificationGui);");
   }
}

//Creates a new profile.
function createNewProfile(%text)
{
   //If the profile cannot be created, return.
   if (slgCreateProfile(%text) == false)
   {
      return false;
   }
   
   //It was created, so update the profile menu text.
   %index = slgGetProfileIndex(createProfileTextField.getText());
   %profileName = "ProfileCtrl" @ %index;
   %control = nameToId(%profileName);
   
   %control.textUp = %text;
   %control.textFocus = %text;
   %control.textDown = %text;
   
   // save our newly created profile after initializing it with new values
   initializeProfile();
   checkForSandbox();
   slgFillProfileMenuSlots();
   updateProfile();
   
   ContinueGameButton.disabled = true;
   LoadGameButton.disabled = true;
   return true;
}

function updateProfileName()
{
   %profileCount = slgGetNumProfiles();
   %profileSelected = slgGetCurrentProfileIndex();
   if (%profileSelected >= 0 && %profileSelected < %profileCount)
   {
      %name = slgGetProfileName(%profileSelected);
      if(strlen(%name) < 10)
      {
         CurrentProfileName.textUp = "Howdy " @ %name;
         CurrentProfileName.disabled = false;
      }
      else
      {
         CurrentProfileName.textUp = %name;
         CurrentProfileName.disabled = false;
      }
   }
   else
   {
      CurrentProfileName.disabled = true;
   }
}

function deleteProfileCancel()
{
   Canvas.popDialog(DeleteProfileGui);
}

function deleteProfileAccept()
{
   %index = $DeleteProfileIndex;
   slgDeleteProfile(%index);
   slgFillProfileMenuSlots();

   // if this was the last profile in the list, the wrong profile
   // will be selected after deletion, so select the correct previous
   // profile (if there is a previous profile to select)   
   %profileSelected = slgGetCurrentProfileIndex();
   %profileCount = slgGetNumProfiles();
   if (%profileSelected >= %profileCount && %profileCount > 0)
   {
      slgSetCurrentProfile(%profileCount - 1);
      
      // load the profile for save game states, awards, etc
      %file = slgGetSaveProfilePath();
      slgLoadProfile(%file);
   }
   
   %slot = slgLastLoadedSave();
   ContinueGameButton.disabled = !slgCanLoadGame() || %slot < 0;
   LoadGameButton.disabled = !slgCanLoadGame();
   sandboxmode.disabled = tsUseTutorialMap();
   updateProfile();
   
   Canvas.popDialog(DeleteProfileGui);
}

$DeleteProfileIndex = 0;
function deleteProfile(%index)
{
   $DeleteProfileIndex = %index;
   %name = slgGetProfileName(%index);
   
   %message = slgGetUIString("id_delete_profile");
   DeleteProfileText.stateUp = slgFormatUIString(%message, %name);
   Canvas.pushDialog(DeleteProfileGui);
}

function slgBuildProfiles()
{
   //Init the profile manager.
   slgBuildProfileManager();
   
   //Fix the profile menu slots to reflect what is in the manager
   slgFillProfileMenuSlots();
   
   //Update main menu text
   slgSetMainMenuWelcomeText();
}

function slgFillProfileMenuSlots()
{
   //Now we should populate the profile list in the profile menu.
   %numProfiles = slgGetNumProfiles();
   for (%index = 0; %index < %numProfiles; %index++)
   {
      %name = slgGetProfileName(%index);
      %profileName = "ProfileCtrl" @ %index;
      %control = nameToId(%profileName);
      
      %control.textUp = %name;
      %control.textFocus = %name;
      %control.textDown = %name;
   }
   
   %numProfiles = slgGetMaxProfiles();
   for (; %index < %numProfiles; %index++)
   {
      %profileName = "ProfileCtrl" @ %index;
      %control = nameToId(%profileName);
      
      %control.textUp = "No Profile";
      %control.textFocus = "No Profile";
      %control.textDown = "No Profile";
   }
}

function slgSetMainMenuWelcomeText()
{
   %profile = slgGetCurrentProfileName();
   %text = "Howdy "@%profile;
   
   trim(%text);
   %text = %text@"!";
}

// this initializes the profile settings
function initializeProfile()
{
   tsResetBadges();
   slgSetTutorial(true);
}

function checkForSandbox()
{
   sandboxmode.disabled = tsUseTutorialMap();
   
   // enable or disable the continue button (depends on current game settings)
   %slot = slgLastLoadedSave();
   ContinueGameButton.disabled = !slgCanLoadGame() || %slot < 0;
   
   // enable the load game button if a game can be loaded
   if (slgCanLoadGame() == true)
   {
      LoadGameButton.disabled = false;
      slgPopulateLoadButtons();
   }
   // disable the load game button
   else
   {
      LoadGameButton.disabled = true;
   }
}

$FramerateTime = 5;
$FramerateCheck = false;
$FramerateTimer = 0;
$FramerateLow = 1000;
$FramerateHigh = 0;
function MenuFramerateChange(%fps)
{
   if ($FramerateCheck == true)
   {
      // if there is no framrate timer, create one
      if (isObject($FramerateTimer) == false)
      {
         $FramerateTimer = new SLTimer()
         {
            time = $FramerateTime;
         };
         $FramerateTimer.notifyOnFire(MenuFramerateStop);
         
         // initialize framerate settings
         $FramerateLow = 1000;
         $FramerateHigh = 0;
         
         // add the gui that prevents the selection of menus
         notificationWindow("Please wait while Westward II determines the best settings for your machine.", "");
         NotificationDone.visible = false;
      }
      
      $FramerateCheck = false;
   }
   
   // if we are querying the framerate
   if (isObject($FramerateTimer) == true)
   {
      // update the high and low framerate checks
      if (%fps < $FramerateLow) $FramerateLow = %fps;
      if (%fps > $FramerateHigh) $FramerateHigh = %fps;
   }
}

function MenuFramerateStop()
{
   // registered framerate benchmarks
   echo("low framerate benchmark = " @ $FramerateLow);
   echo("high framerate benchmark = " @ $FramerateHigh);
   
   // CURRENT SETTINGS (may need to change)
   // FPS         DETAIL      MODEL       TERRAIN     OVERALL
   // 70+         high        high        high        high
   // 60-70       medium      high        high        medium-high
   // 50-60       low         high        high        medium
   // 50-         low         low         low         low
   
   // set the detail settings
   if ($FramerateHigh < 60)
   {
      echo("Setting Low Detail Options Mode");
      LowDetailButton.buttonSelect();
   }
   else if ($FramerateHigh < 70)
   {
      echo("Setting Medium Detail Options Mode");
      MediumDetailButton.buttonSelect();
   }
   
   // set the model texture settings
   if ($FramerateHigh < 50)
   {
      echo("Setting Low Model Texture Options Mode");
      LowModelButton.buttonSelect();
   }
   
   // set the terrain texture settings
   if ($FramerateHigh < 50)
   {
      echo("Setting Low Terrain Texture Options Mode");
      LowTerrainButton.buttonSelect();
   }
   
   // this is where all of the settings will be modified based
   // on the changes that were
   Canvas.popDialog(NotificationGui);
   NotificationDone.visible = true;
}

$ExitRemoveGameMenu = false;
$ExitInProgress = false;
function MenuExitGame()
{
   slgStackPause();
   Canvas.pushDialog(ExitGameGui);
   
   $ExitRemoveGameMenu = false;
   $ExitInProgress = true;
   if ($GameMenuLoaded == false)
   {
      $GameMenuLoaded = true;
      $ExitRemoveGameMenu = true;
   }
}

function MenuAcceptExitGame()
{
   slgStackUnpause();
   exitGame();
   
   $ExitInProgress = false;
   if ($ExitRemoveGameMenu == true)
   {
      $GameMenuLoaded = false;
   }
}

function MenuCancelExitGame()
{
   Canvas.popDialog(ExitGameGui);
   slgStackUnpause();
   
   $ExitInProgress = false;
   if ($ExitRemoveGameMenu == true)
   {
      $GameMenuLoaded = false;
   }
}
